 /*****************************************************************************

    Javascript simulation of the Anita 1000 LSI electronic calculator
    Copyright (c) 2004 Simon Southwell

    simon_southwell@bigfoot.com
    17th February 2004, Bristol, UK

    $Id: A1000.js,v 1.3 2004/07/17 14:57:13 Simon Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Anita 1000 LSI images in this simulator have been used with 
    permission of Simon Southwell Copyright (c) 2004 Simon Southwell.

 *****************************************************************************/

var is_netscape = (navigator.appName=="Netscape") ? 1 : 0;
var title  = document.title;
var is_1011 = title.indexOf(" 1011") != -1;

// Image directories
var leddir="images/";
var switchdir="images/"

// Preload dynamic images
led0         = new Image(25, 52); led0.src=leddir+"t0.jpg";
led1         = new Image(25, 52); led1.src=leddir+"t1.jpg";
led2         = new Image(25, 52); led2.src=leddir+"t2.jpg";
led3         = new Image(25, 52); led3.src=leddir+"t3.jpg";
led4         = new Image(25, 52); led4.src=leddir+"t4.jpg";
led5         = new Image(25, 52); led5.src=leddir+"t5.jpg";
led6         = new Image(25, 52); led6.src=leddir+"t6.jpg";
led7         = new Image(25, 52); led7.src=leddir+"t7.jpg";
led8         = new Image(25, 52); led8.src=leddir+"t8.jpg";
led9         = new Image(25, 52); led9.src=leddir+"t9.jpg";
ledoff       = new Image(25, 52); ledoff.src=leddir+"toff.jpg";
ledminus     = new Image(15, 52); ledminus.src=leddir+"minus.jpg";
leddoton     = new Image(15, 52); leddoton.src=leddir+"dot_on.jpg";
leddotoff    = new Image(15, 52); leddotoff.src=leddir+"dot_off.jpg";
leddotminus  = new Image(15, 52); leddotminus.src=leddir+"dot_minus.jpg";

switchon     = new Image(91, 40); switchon.src=switchdir+"on.jpg";
switchonclr  = new Image(91, 40); switchonclr.src=switchdir+"on_clear.jpg";
switchoff    = new Image(91, 40); switchoff.src=switchdir+"off.jpg";
switchoffclr = new Image(91, 40); switchoffclr.src=switchdir+"off_clear.jpg";


// State of the switches
var sw_on = false;
var sw_clr = false;

// Main registers
var x;                          // Result register
var y;                          // Input register
var k;                          // Constant register

var k_pnt;                      // Constant has leading point
var y_pnt;                      // Input reg has leading point
var x_pnt;                      // Result reg has leading point
var disp;                       // Display string
var ip_dp;                      // Number of entered decimal places at input
var is_new_num;                 // Flags start of a new number entry
var is_decimal;                 // Flags that the decimal point has been pressed
var last_key;                   // Last key pressed
var ljust;                      // left justify values < 1

// Constant declarations (don't use 'const' which causes compatibility issues)
var RNDFACTOR   = 1000000000;   // Rounding factor
var WRAPMAX     = 999999999;    //
var MAXDISPLEN  = 12;           // Max length of disp string
var MAXDISPLENP = 11;           // Max length of disp string when positive
var NOMATCH     = -1;           // Match fail return value
var RUNTEST     = 0x74;

// List of valid input
var valid_keys = is_1011 ? ".0123456789+-*/CoerprsE" : ".0123456789+-*/Coe";

// Only tested sound on Internet Explorer. NB. Opera users must noy
// advertise themselves as Internet Explorer---otherwise it won't
// work
var ver = parseInt(navigator.appVersion);
var en_sound = false;

// ---------------------------------------------------------
//
function initialise() {

    var dp;

    x = Math.random() * 9999999999;             // Random number between o a MAX
    dp = Math.floor(Math.random() * 10);        // Random number of dp shifts
    x = x/(Math.pow(10,dp));                    // Random startup number

    y = 0;
    k = x;

    k_pnt = false;
    x_pnt = false;
    y_pnt = false;

    disp = x.toString();
    last_key = '';
    ip_dp = 0;
    is_new_num = true;
    is_decimal = false;
    ljust = false;

    if (ver > 3 && navigator.appName.indexOf("Microsoft") != -1)
        en_sound = true;
}

// ---------------------------------------------------------
// 
function rnd_for_disp(Val) {
    
    var Num;
    var rfact = RNDFACTOR;

    // Scale round factor for number of displayed decimal points
    Num = (Val < 0) ? 0 - Val : Val;

    if (Num < 10) 
        rfact = 1000000000000;
    else 
        while(Math.floor(Num) >= 10) {
            Num /= 10;
            rfact /= 10;
        }

    // Try and correct rounding errors
    Num = Math.round(Val * rfact)/rfact;

    // Wrap decimal place if necessary
    if (Num < (-1*WRAPMAX) || Num > (WRAPMAX))
        Num = Num / 10000000000;

    return Num;
}

// ---------------------------------------------------------
// Convert a real number to a display string
//
function num_to_disp(num) {

    var is_neg;

    // Convert number to string
    disp = num.toString();

    is_neg = (disp.charAt(0) == '-');

    if (ljust && (num > -1 && num < 1)) {
        disp = is_neg ? disp.charAt(0) + disp.substring(2, disp.length) : disp.substring(1, disp.length);
    }

    // Truncate disp if necessary
    if (disp.length > (is_neg ? MAXDISPLEN : MAXDISPLENP))
        disp = disp.substring(0, (is_neg ? MAXDISPLEN : MAXDISPLENP));

    // Append a '.' if none exists
    if (disp.indexOf('.') == NOMATCH)
        disp = disp+'.';

    // Pad with zeros
    while (disp.length < (is_neg ? MAXDISPLEN : MAXDISPLENP)) 
        disp = disp+'0';

}

// ---------------------------------------------------------
// Update display graphics from disp value
//
function update_display(dspin) {

    var disp_array = new Array();
    var dot_active = false;             // True when processing decimal digits
    var is_negative;
    var dsp;
    var idx;

    dsp = dspin;

    if (!sw_on) {
        for (idx = 0; idx < 10; idx++) {
            disp_array[idx*2] = ledoff.src;
            disp_array[idx*2+1] = leddotoff.src;
        }
    } else {

        is_negative = dsp.charAt(0) == '-';

        // Pad with zeros
        while (dsp.length < (is_negative ? MAXDISPLEN : MAXDISPLENP)) 
            dsp = dsp+'0';

        idx = 0;
        leds = 10;
        while (leds > 0) {
            digit   = dsp.charAt(idx);
            if (digit == '.') {
                dot_active = true;
            } else if (digit && "0123456789".indexOf(digit) != NOMATCH) {
                leds--;
                if (dot_active)
                    disp_array[leds*2+1] = (idx == 2 && is_negative) ? leddotminus.src : leddoton.src;
                else 
                    disp_array[leds*2+1] = (idx == 1 && is_negative) ? ledminus.src : leddotoff.src;

                disp_array[leds*2] = leddir+"t"+digit+".jpg";
                dot_active = false;
            }

            idx++;
        }
    }

    // Update display
    document.d9.src = disp_array[19];
    document.t9.src = disp_array[18];
    document.d8.src = disp_array[17];
    document.t8.src = disp_array[16];
    document.d7.src = disp_array[15];
    document.t7.src = disp_array[14];
    document.d6.src = disp_array[13];
    document.t6.src = disp_array[12];
    document.d5.src = disp_array[11];
    document.t5.src = disp_array[10];
    document.d4.src = disp_array[9];
    document.t4.src = disp_array[8];
    document.d3.src = disp_array[7];
    document.t3.src = disp_array[6];
    document.d2.src = disp_array[5];
    document.t2.src = disp_array[4];
    document.d1.src = disp_array[3];
    document.t1.src = disp_array[2];
    document.d0.src = disp_array[1];
    document.t0.src = disp_array[0];
}

// ---------------------------------------------------------
//
function reduce(Key)
{
    var op;
    var op_pnt;
    var new_x;

    op = sw_clr ? k : x;
    op_pnt = sw_clr ? k_pnt : x_pnt;

    if (Key == '+') 
       new_x = op + y;
    else if (Key == '-') 
       new_x = sw_clr ? y - op : op - y;
    else if (Key == '/') 
       new_x = sw_clr ? y / op : op / y;
    else if (Key == '*') {
       new_x = op * y;
       if (op_pnt && y_pnt) {
            new_x = new_x * 10000000000;
       }
    }

    x = rnd_for_disp(new_x);

    ljust = ("*/".indexOf(Key) != NOMATCH) && (x > -1 && x < 1);

}

// ---------------------------------------------------------
//
function key_pressed(key) {

    ljust = false;
    curr_key = key;


    // Not switched on! 
    if (!sw_on) {
        if (en_sound)
            document.keysnd.play();
        return; 
    }

    // Process a number key. Process 0 only if other numbers entered
    else if ((key && "0123456789".indexOf(key)) != NOMATCH) {

        // Don't process key if input register (display) full
        if (!is_new_num && disp.length == MAXDISPLENP) {
            if (en_sound)
                document.keysnd.play();
            return;
        }

        // If entering a tenth non-decimal digit, reset decimal pointo to top
        if (!is_new_num && disp.length == MAXDISPLENP-1 && !is_decimal) {
            disp = '.'+disp.substring(0, disp.length-1)+key;
            ip_dp = 10;
        } 

        // If decimal active, simply append number
        else if (is_decimal) {
            disp = disp+key;
            ip_dp = ip_dp + 1;
        // If decimal not active keep decimal at the end
        } else {
            ip_dp = 0;
            y_pnt = false;
            if (is_new_num) 
                disp = key+'.';
            else 
                disp = disp.substring(0, disp.length-1)+key+'.';
        }

        y = parseFloat(disp);
        y_pnt = disp.charAt(0) == '.';

        // Number not new after first key press
        is_new_num = false;
    }
    else if (key == '.') {

        if (!is_decimal)
            ip_dp = 0;

        // If '.' is the first key of a new number, imply '0'
        // already pressed.
        if (is_new_num) {
            disp = ".";
            is_new_num = false;
        } 

        is_decimal = true;

    } else if ("*/+-".indexOf(key) != NOMATCH) {

        if (key == '/' && last_key == '-') {
            y = x;
            y_pnt = x_pnt;
         }

        if (key == '*' && last_key == '/') {
            x = k;
            x_pnt = k_pnt;
        } else 
            reduce(key);

        num_to_disp(x);
        is_new_num = true;
        is_decimal = false;

    } else if (key == 'e') {
        if (!sw_clr) {
            x = parseFloat(disp);
            x_pnt = y_pnt;    
            k = x;
            k_pnt = x_pnt;
        }
        is_new_num = true;
        is_decimal = false;
    }

    last_key = key;

    // Update display
    update_display(disp);

    if (en_sound)
        document.keysnd.play();

}

// ---------------------------------------------------------
//
function switch_on() {
    sw_on = !sw_on;
    if (sw_on) {
        document.switches.src = sw_clr ? switchonclr.src : switchon.src;
        initialise();
    } else {
        document.switches.src = sw_clr ? switchoffclr.src : switchoff.src
    }

    update_display(disp);

    if (en_sound)
        if(sw_on)
            document.swonsnd.play();
        else
            document.swoffsnd.play();
}

// ---------------------------------------------------------
//
function switch_clear() {
    sw_clr = !sw_clr;
    if (sw_clr)  {
        document.switches.src = sw_on ? switchonclr.src : switchoffclr.src;
        k = parseFloat(disp);
    } else 
        document.switches.src = sw_on ? switchon.src : switchoff.src;

    is_new_num = true;
    is_decimal = false;

    if (en_sound)
        if (sw_clr)
            document.swonsnd.play();
        else
            document.swoffsnd.play();
}

// ---------------------------------------------------------
//
function logo() {

  // Display an 'about' message
  alert('A JavaScript Anita 1000 LSI simulator\n' +
        'by Simon Southwell (simon_southwell@bigfoot.com)\n' +
        'February 2004, Bristol, UK.\n\n' +
        'RELEASE_YYYY_MM_DD');
}

// ---------------------------------------------------------
//
function keyboard(e) {

    var ky, code;

    code = is_netscape ? e.which : e.keyCode;

    // Execute test on ^T
    if (code == RUNTEST) {
        test();                 // Uncomment to enable testing
        return;
    }

    // Extract key value from event and convert to character
    ky = String.fromCharCode(code);

    // Ignore all key presses that are not mapped
    if (valid_keys.indexOf(ky) == NOMATCH) 
        return; 

    // Catch keys for changing switches
    if (ky == 'o')
        switch_on();
    else if (ky == 'C')
        switch_clear();
    // All other key presses passed on
    else
        key_pressed(ky);
}

// ---------------------------------------------------------
//
function mouse_down(e) {

    var elem = e.srcElement;
    var str = elem.toString();
    var c = str.charAt(24);

    if (c != "" && "e+-/*".indexOf(c) != NOMATCH && sw_on)
        update_display("0.0");

}

// ---------------------------------------------------------
//
// Test data string format is:
//
// <input key sequence> : <expected displayed result> @ ....
//
// Spaces in the input sequence are ignored (but don't use tabs).

testdata = "oo0e:0.000000000@" +                                     // initialise
"7 e 39 + 963 +                            :  1009.000000 @" +       // test 1
"85 e 32 - 156.25 -                        : -103.2500000 @" +
".0875 e 1025 - 2638 +                     :  1613.087500 @" +
"73.5 e 3.049 * .06 * 10.35 *              :  139.1670315 @" +
"710.775 e 54 / .000208 / 99.45 /          :  636.3122172 @" +
"98765.12345 e 987.1234567 * 12345.01234 / :  7897.389438 @" +
"2.389375 C 951.625 *                      :  2273.788984 @" +
"           987654 *                       :  2359875.776 @" +
"           1149.25 /                      :  480.9835208 @" +
"           12345679 / C                   :  5166907.246 @" +       // test 10
"778.113 e .625 /                          :  1244.980800 @" +
"        * 4.375 /                         :  177.8544000 @" +
"        * 287.5 /                         :  2.706480000 @" +
"8.17 e *                                  :  66.74890000 @" +
"1.9375 e * *                              :  7.273193359 @" +
"117500 e 82250 + C 225347 / C             :  1.128145181 @" +
"8 e / /                                   :  .1250000000 @" +
".125 e / -                                :  0.875000000 @" +
"240678 C 265916 -                         :  025238.0000 @" +
"/ C 100 *                                 :  10.48620980 @" +       // test 20
"265916 C 240678 -                         : -25238.00000 @" +
"/ C 100 *                                 : -09.49096708 @" +       // End of manual tests
"22 e 7 /                                  :  3.142857142 @" +
"9999999991 e                              :  .9999999991 @" +
" 10 /                                     :  .0999999999 @" +
"999999999 e                               :  999999999.0 @" +
" 10 *                                     :  .9999999990 @" +
".035 e .0056 *                            :  001960000.0 @" +
"0.035 e 0.0056 *                          :  0.000196000 @" + 
"oo0e:0.000000000"; // last line

testdata1011 = "oo0e:0.000000000@" +                                 // initialise
"7 e 65 + 954 +                            :  1026.000000 @" +       // test 1
"85 e 32 - 154.25 -                        : -101.2500000 @" +
".25 e 1002 - 3025 +                       :  2023.250000 @" +
"23 e 36 *                                 :  828.0000000 @" +
"3.25 e 4.5 * 14 *                         :  204.7500000 @" +
"142 e 12.5 /                              :  11.36000000 @" +
"1728 e 3 / 12 /                           :  48.00000000 @" +
"98765.12345 e 987.1234567 * 12345.01234 / :  7897.389438 @" +
"285 e p * r                               :  35.63000000 @" +
"365 e p / r                               :  55.81000000 @" +
"240678 C 265916 - % / r C                 :  10.49000000 @" +
"265916 C - % / r C                        : -9.490000000 @" +
"12 e 13 * E                               :  156.0000000 @" +
"14 e 15 * s +                             :  366.0000000 @" +
"16 e 17 * s +                             :  638.0000000 @" +
"0.02 e 0.03 * E +                         :  .0006000000 @" +
"0.05 e 9.07 * s +                         :  .0041000000 @" +
"0.06 e 0.12 * s +                         :  .0113000000 @" +
"147 e 2.12 * E				   :  311.6400000 @" +
"195 e .175 * r s +                        :  330.0200000 @" +
"9 e 3.87 * s +                            :  364.8500000 @" +
"8 * p r s -                               :"  +
"oo0e:0.000000000" ; // last line

// ---------------------------------------------------------
function test() {

    var answer = false;                 // State indicating reading expected answer
    var testnum = 0;                    // test number
    var failures = new Array();         // List of test failures
    var fidx = 0;                       // Failure index
    var testchar = "";                  // Current input character

    if (!confirm("Run the self tests?\n(may take some seconds)"))
        return;

    // Ensure calculator is switched on
    if (!sw_on)
        switch_on();

    // Scan through all test data ...
    for (tidx = 0; tidx < (is_1011 ? testdata1011.length : testdata.length); tidx = tidx + 1) {

        // get next input character
        testchar = is_1011 ? testdata1011.charAt(tidx) : testdata.charAt(tidx);

        // Non white-space input
        if (testchar != ' ') {
            // If answer delimiter, clear expected answer string and set state
            if (testchar == ':') {
                answer = true;
                expected = "";
            }
            // If test delimiter, check answer
            else if (testchar == '@') {
                // Clear state
                answer = false;

                // Get calculator's result
                result = disp;

                // Pad with zeros
                while (result.length < ((result.charAt(0) == '-') ? MAXDISPLEN : MAXDISPLENP)) 
                    result = result+'0';

                // Check result matches expected, and log if not
                if (parseFloat(expected) != parseFloat(result)) 
                    failures[fidx++] = testnum;
 
                // Check for equal number of decimal places
                if (expected.indexOf('.') == NOMATCH)
                    expected = expected + '.';
                if ((expected.length - expected.indexOf('.')) != (result.length - result.indexOf('.')))
                    failures[fidx++] = testnum;

                testnum++;
            }
            // Whilst in answer state, append input to expected variable
            else if (answer == true)
                expected = expected + testchar;
            // Input key sequences
            else {
                // Abort if an invalid character found in the test data
                if (valid_keys.indexOf(testchar) == NOMATCH) {
                    alert("Invalid input character ("+testchar+") in test sequence\n"+
                          "at line "+testnum);
                    return;
                }

                // Process switch keys here
                if (testchar == 'o')
                    switch_on();
                else if (testchar == 'C')
                    switch_clear();
                // All other test keys passed on
                else
                    key_pressed(testchar);
            }
        }
    }

    // Clear testchar and reuse for failure message
    testchar = "";

    // Add all failure test numbers to string
    for (tidx = 0; tidx < fidx; tidx++) 
        testchar = testchar + " " + failures[tidx];

    // Display test results
    if (fidx > 0)
        alert (fidx+" failures at lines:"+testchar);
    else
        alert ("All "+ (testnum-1) + " tests pass");

}
