 /*****************************************************************************

    Javascript simulation of the Anita 831 electronic calculators
    Copyright (c) 2004-2006 Simon Southwell

    simon_southwell@bigfoot.com
    25th March 2004, Bristol, UK

    $Id: anita831.js,v 1.7 2004/10/27 20:06:38 Simon Exp $

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Anita 831 images in this simulator Copyright (c) 2004 Simon Southwell.

 *****************************************************************************/

var is_netscape = (navigator.appName=="Netscape") ? 1 : 0;

leddir="../common/anita/images/"
var switchdir="images/"

// Preload dynamic images
led0 = new Image(14, 15); led0.src=leddir+"led0.jpg";
led1 = new Image(14, 15); led1.src=leddir+"led1.jpg";
led2 = new Image(14, 15); led2.src=leddir+"led2.jpg";
led3 = new Image(14, 15); led3.src=leddir+"led3.jpg";
led4 = new Image(14, 15); led4.src=leddir+"led4.jpg";
led5 = new Image(14, 15); led5.src=leddir+"led5.jpg";
led6 = new Image(14, 15); led6.src=leddir+"led6.jpg";
led7 = new Image(14, 15); led7.src=leddir+"led7.jpg";
led8 = new Image(14, 15); led8.src=leddir+"led8.jpg";
led9 = new Image(14, 15); led9.src=leddir+"led9.jpg";

led0dot = new Image(14, 15); led0dot.src=leddir+"led0dot.jpg";
led1dot = new Image(14, 15); led1dot.src=leddir+"led1dot.jpg";
led2dot = new Image(14, 15); led2dot.src=leddir+"led2dot.jpg";
led3dot = new Image(14, 15); led3dot.src=leddir+"led3dot.jpg";
led4dot = new Image(14, 15); led4dot.src=leddir+"led4dot.jpg";
led5dot = new Image(14, 15); led5dot.src=leddir+"led5dot.jpg";
led6dot = new Image(14, 15); led6dot.src=leddir+"led6dot.jpg";
led7dot = new Image(14, 15); led7dot.src=leddir+"led7dot.jpg";
led8dot = new Image(14, 15); led8dot.src=leddir+"led8dot.jpg";
led9dot = new Image(14, 15); led9dot.src=leddir+"led9dot.jpg";

ledoff   = new Image(14, 15); ledoff.src=leddir+"ledoff.jpg";
ledminus = new Image(14, 15); ledminus.src=leddir+"ledminus.jpg";
lede     = new Image(14, 15); lede.src=leddir+"ledsq.jpg";

switchon  = new Image(35, 17); switchon.src=switchdir+"switchon.jpg";
switchoff = new Image(35, 17); switchoff.src=switchdir+"switchoff.jpg";

// State of the switches
var batt_on         = false;
var rnd_on          = false;
var decimal_on      = false;
var suspend_decimal = false;

var x=0;                     // Accumulator
var y=0;                     // Input/display register
var m=0;                     // Memory register
var k=0;                     // Constant register
var k_op = "";               // Constant operation

var disp       = "0.";       // Display in string format
var is_new_num = true;       // New number to be input
var is_decimal = false;      // Input has decimal active
var last_op    = "";         // Last operation key pressed
var error      = false;      // Overflow/undeflow error
var infinity   = false;      // Infinity (divide by 0)
var mem_pend   = false;      // Memory key ('m') pressed

// Valid key inputs
var validkeys = "0123456789.+-*/=cm%sord";

// Constant values
var RUNTEST     = 0x74;
var NOMATCH = -1;                             // Match fail return value
var MINVAL  = -99999999;                      // Minimum value
var MAXVAL  =  99999999;                      // Maximum value
var RNDFACTOR = 100000000;                    // Rounding factor

// ---------------------------------------------------------

function update_display(dspin) {

    var disp_array = new Array();
    var dot_active = false;
    var dsp=dspin;
    var leds=0;
    var idx=dsp.length;

    if (dspin.indexOf('.') == NOMATCH) {
        dsp = dspin + '.';
        idx++;
    } else {
        while (dsp.length > 9 && dsp.charAt(dsp.length-1) != ".") {
            dsp = dsp.substring(0, dsp.length-1);
	    idx--;
        }
    }

    if (error)
        document.dm.src = lede.src;
    else if (dsp.charAt(0) == '-')
        document.dm.src = ledminus.src;
    else
        document.dm.src = ledoff.src;

    // Fill in the main display array
    while (leds < 8) {
        idx--;
        digit = dsp.charAt(idx);
        if (digit == '.') 
            dot_active = true;
        else if (digit && "0123456789".indexOf(digit) != NOMATCH) {
            if (dot_active) 
                disp_array[leds] = leddir+"led"+digit+"dot.jpg";
            else
                disp_array[leds] = leddir+"led"+digit+".jpg";
            dot_active = false;
            leds++;
        } else {
            disp_array[leds] = ledoff.src;
            leds++;
        }
    }

    // Update display
    document.d7.src = disp_array[7];
    document.d6.src = disp_array[6];
    document.d5.src = disp_array[5];
    document.d4.src = disp_array[4];
    document.d3.src = disp_array[3];
    document.d2.src = disp_array[2];
    document.d1.src = disp_array[1];
    document.d0.src = disp_array[0];
}

// ---------------------------------------------------------

function initialise() {
   x = 0;
   y = 0;
   k = 0;
   k_op = "";
   last_op = "";
   disp = "0.";
   is_new_num = true;
   is_decimal = false;
   mem_pend = false;
   error = false;
}

// ---------------------------------------------------------

function rnd_to_display(valin, op) {

    var rnd_factor;
    var val;
    var result;

    val = Math.round(valin * RNDFACTOR)/RNDFACTOR;

    result = (val < 0) ? -1 * val : val;

    if (result < 1e-7)
        return 0;

    if ("*/".indexOf(op) != NOMATCH) {
        if (rnd_on) {
            rnd_factor = 100;
            result = (Math.round(val * rnd_factor))/rnd_factor;
        } else {
            rnd_factor = 10000000;
            while (result >= 10) {
                result = result / 10;
                rnd_factor = rnd_factor / 10;
            }
            result = (Math.floor(val * rnd_factor))/rnd_factor;
        }
    } else {
        result = Math.round(val * 10000000)/10000000;
    }

    return result;
}

// ---------------------------------------------------------

function num_to_string(n) {

    var s = n.toString();
    var i;

    i = s.indexOf('e');
    if (i != NOMATCH) {
        tmp = s.substring(i+1, s.length);
        exp = tmp.valueOf();
	if (exp < -7)
	    s = "0.";
        else {
	    if (n > 0)
	        s = "0.000000" + s.charAt(0);
	    else
	        s = "-0.000000" + s.charAt(1);
        }
    }
    
    return s;
}

// ---------------------------------------------------------


function reduce (op) {

    if (op == '+')
        x = x + y;
    if (op == '-')
        x = x - y;
    if (op == '*')
        x = x * y;
    if (op == '/') {
        // Trap divide by 0
        if (y == 0) {
            infinity = true;
            error = true;
            x = 0;
            return;
        }  
        x = x / y;
    }

    // Check for out-of-range, and rescale
    if (x < MINVAL || x > MAXVAL) {
        error = true;
        x = x / RNDFACTOR;
    }

    x = rnd_to_display(x, op);

}

// ---------------------------------------------------------
// Callback when battery switch is changed
//
function sw_batt() {
    batt_on = !batt_on
    document.batt_img.src = batt_on ? switchon.src : switchoff.src;
    if (batt_on) {
        initialise();
        m = 0;
    } else {
        disp = "";
        flow_err = false;
    }

    update_display(disp);
}

// ---------------------------------------------------------
// Callback when rounding switch is changed
//
function sw_round() {
    rnd_on = !rnd_on;
    document.rnd_img.src = rnd_on ? switchon.src : switchoff.src;
}

// ---------------------------------------------------------
// Callback when mem switch is changed
//
function sw_decimal() {
    decimal_on = !decimal_on;
    document.dec_img.src = decimal_on ? switchon.src : switchoff.src;
}
// ---------------------------------------------------------

function keyboard(e) {

    var ky;

    code = is_netscape ? e.which : e.keyCode;
    ky = String.fromCharCode(code);

    if (code == RUNTEST)
        test();
    else if (validkeys.indexOf(ky) == NOMATCH)
        return;
    // Catch keys for changing switches
    else if (ky == 'o')
        sw_batt();
    else if (ky == 'd')
        sw_decimal();
    else if (ky == 'r')
        sw_round();
    // All other key presses passed on
    else
        key_pressed(ky);
}

// ---------------------------------------------------------

function key_pressed(key) {

    var length;

    if ((error && key != 'c') || !batt_on)
        return;

    if (".0123456789".indexOf(key) == NOMATCH)
        suspend_decimal = false;

    // Numeric input
    if ((key && ".0123456789".indexOf(key)) != NOMATCH) {

        if (key == '.') {

            if (is_new_num) {
                disp = "0.";
                is_new_num = false;
            } 
            is_decimal = true;

	    if (decimal_on && !suspend_decimal) {
	        disp = disp.substring(0, disp.indexOf('.')) + disp.substring(disp.indexOf('.')+1, disp.length) + '.';
		while(disp.charAt(0) == '0')
		    disp = disp.substring(1, disp.length);
	        suspend_decimal = true;
	    }

        } else {
            if (!is_new_num && disp.length == 9)
                return;

	    if (decimal_on && ! suspend_decimal) {
	        if (is_new_num) {
		    disp = "0.0" + key;
                    is_new_num = false;
	        } else if (disp.substring(0, 3) == "0.0") {
		    disp = "0." + disp.charAt(3) + key;
	        } else if (disp.substring(0, 2) == "0.") {
		    disp = disp.charAt(2) + "." + disp.charAt(3) + key;
		} else {
		    length = disp.length;
		    disp = disp.substring(0, length-3) + disp.charAt(length-2) + "." + 
		           disp.charAt(length-1) + key;
	        }
            } else if (is_decimal)
                disp = disp+key;
            else if (y == 0 && key == '0') {
                disp = "0.";
                y = 0;
                return;
            } else {
                if (is_new_num) 
                    disp = key+'.';
                else 
                    disp = disp.substring(0, disp.length-1)+key+'.';
            }

            y = parseFloat(disp);

            is_new_num = false;
            mem_pend = false;
    
        }
    // Operator input
    } else if ("*/+-".indexOf(key) != NOMATCH && !mem_pend) {

        if (last_op != "") {
            reduce(last_op);
            disp = num_to_string(x);
        } else 
           x = y;

        is_new_num = true;
        is_decimal = false;
        last_op = key;

    // Equals input
    } else if ("=%".indexOf(key) != NOMATCH && !(mem_pend && key == '=')) {

        // If an op key pending, save input and op as constant
        if (last_op != "") {
            k = (last_op == '*') ? x : y;
            k_op = last_op;
        // If no pending op, copy input to x, and use constant
        } else {
            x = y;
            y = k;
            last_op = k_op;
        }

        // Percent scales input by 100
        if (key == '%')
            y = y/100;

        // Percent after + or -, work out %, then add/subtract
        // to original accumulator value
        if (key == '%' && ("+-".indexOf(last_op) != NOMATCH)) {
            tmp = x;
            reduce('*');
            y = x;
            disp = num_to_string(y);
            x = tmp;

        // Calculate result into x, and place in input register
        } else {
            reduce(last_op);
            y = x;
            disp = num_to_string(y);

            last_op = "";
        }
        is_new_num = true;
        is_decimal = false;
        mem_pend = false;

    // Memory operation
    } else if (mem_pend) {
        if (key == '+')
            m += parseFloat(disp);
        else if (key == '-')
            m -= parseFloat(disp);
        else if (key == 'c')
            m = 0;
        else if (key == '=') {
            y = m;
            y = rnd_to_display(y, "+");
            disp = num_to_string(y);
        }

        mem_pend = false;
        is_new_num = true;
        is_decimal = false;

    // Auxilliary operation input
    } else {
        // Square root
        if (key == 's') {
            y = Math.sqrt(y);
            y = rnd_to_display(y, "*");
            disp = num_to_string(y);
            
            mem_pend = false;
            is_new_num = true;
            is_decimal = false;

        // Memory key 
        } else if (key == 'm') {
            mem_pend = true;

        // Clear key
        } else if (key == 'c') {
            // Clear error
            if (error) {
                error = false;
                infinity = false;
                y = x;
                disp = num_to_string(y);
            // Clear input
            } else if (!is_new_num) {
                y = 0;
                disp = "0.";
            // Reset all
            } else 
                initialise();

            is_new_num = true;
            is_decimal = false;
            mem_pend = false;
        }
    }

    update_display(disp);
}

// ---------------------------------------------------------

function logo() {

  // Display an 'about' message
  alert("A JavaScript Anita 831 simulator\n" +
        "by Simon Southwell (simon_southwell@bigfoot.com)\n" +
        "March 2004, Bristol, UK.\n\n" +
        "RELEASE_2006_01_07");
}

// ---------------------------------------------------------

testdata = "oo:0.@" +                                     // initialise
"12 * 13 =                  : 156. @" +                    // p4
"13 * 14 * 15 =             : 2730. @" +
"252 / 18 =                 : 14. @" +
"9 * 36 / 25 =              : 12.96 @" +
"6 * 5 =                    : 30. @" +
"    7 =                    : 42. @" +
"78 / 12 =                  : 6.5 @" +
"48 =                       : 4. @" +
"6 + 23 + 147 =             : 176 @" +                     // p5
"d 4125 + 102 + 36 + 500 =  : 47.63 @" +
"  3650 - 1236 =           d: 24.14 @" +
"r 285 * 12.5 %             : 35.63 @" +                   // p6
"365 / 654 %               r: 55.81 @" +
"mc 6 * 7 = m +             : 42. @" +
"   8 * 9 = m +             : 72. @" +
"   4 * 5 = m -             : 20. @" +
"           m =             : 94. @" +
"r6 * 8.75 =                : 52.50 @" +                   // p7
"  - 5 %                    : 2.63 @" +
"      =                    : 49.87 @" +
"  + 10 %                   : 4.99 @" +
"      =                    : 54.86 @" +
"mc 5 * 3.25 = m +          : 16.25 @" +
"3 * 2.14 = m +             : 6.42 @" +
"m =                        : 22.67 @" +
" * 6.5 % m -               : 1.47 @" +
"m =                        : 21.20 @" +
"* 10 % m +                 : 2.12 @" +
"m =                        : 23.32 @" +
"  147 + 258 + 369 + 654 =  : 1428. @" +                   // p8
" / =                       : 1. @" +
"mc 147 % m +               : 10.29 @" +
" 258 % m +                 : 18.07 @" +
" 369 % m +                 : 25.84 @" +
" 654 % m +                 : 45.80 @" +
" m =                       : 100.00 @" +
"265 - 240 / %              : 10.42 @" +                   // p9
"240 - 265 / %              : -9.43 @" +
"0 - 21.96 + 24 / %         : 8.5 @" +                     // p10
"mc 24 m + - 21.96 / m = % r: 8.5 @" +
"3 + 2 * 12 =               : 60. @" +                     // p11
"54 / 6 - 2 =               : 7. @" +
"5 * 6 * 7 + 8 / 9 - 10 =   : 14.222222 @" +               // Manual gives 14.2, with no rounding ??
"8 / / =                    : 0.125 @" +
".125 / - =                 : 0.875 @" +
"5 * =                      : 25. @" +                     // p12
"4 * * =                    : 64. @" +
"1.3 * = * =                : 2.8561 @" +
"1.21 * = * = * =           : 4.5949729 @" +
"1764 s                     : 42. @" +                     // p13
"4 * 5 * 6 = s              : 10.954451 @" +
"3 s * 2 =                  : 3.4641016 @" +
"9 s / = 4 =                : 1.3333333 @" +              // Manual gives 1.3 ??
"91.36 + 115.875 / 81.61 -  : 2.5393334 @" +
"   2.37 * 96.45 /          : 16.332206 @" +
"   1.075 = = = = s         : 3.497079 @" +
"mc 3 * = m+ 4 * = m+ m = s : 5. @" +
"oo:0.";                                                  // last line

// ---------------------------------------------------------
function test() {

    var answer = false;                 // State indicating reading expected answer
    var testnum = 0;                    // test number
    var failures = new Array();         // List of test failures
    var fidx = 0;                       // Failure index
    var testchar = "";                  // Current input character

    if (!confirm("Run the self tests?\n(may take some seconds)"))
        return;

    if (!batt_on)
        sw_batt();
    if (rnd_on)
        sw_round();
    if (decimal_on)
        sw_decimal();

    // Scan through all test data ...
    for (tidx = 0; tidx < testdata.length; tidx = tidx + 1) {

        // get next input character
        testchar = testdata.charAt(tidx);

        // Non white-space input
        if (testchar != ' ') {
            // If answer delimiter, clear expected answer string and set state
            if (testchar == ':') {
                answer = true;
                expected = "";
            }
            // If test delimiter, check answer
            else if (testchar == '@') {
                // Clear state
                answer = false;

                // Get calculator's result
                result = disp;

                // Check result matches expected, and log if not
                if (parseFloat(expected) != parseFloat(result)) 
                    failures[fidx++] = testnum;
 
                testnum++;
            }
            // Whilst in answer state, append input to expected variable
            else if (answer == true)
                expected = expected + testchar;
            // Input key sequences
            else {

                // Abort if an invalid character found in the test data
                if (validkeys.indexOf(testchar) == NOMATCH) {
                    alert("Invalid input character ("+testchar+") in test sequence\n"+
                          "at line "+testnum);
                    return;
                }

                if (testchar == 'o')
                    sw_batt();
                else if (testchar == 'd')
                    sw_decimal();
                else if (testchar == 'r')
                    sw_round();
                else
                    key_pressed(testchar);
            }
        }
    }

    // Clear testchar and reuse for failure message
    testchar = "";

    // Add all failure test numbers to string
    for (tidx = 0; tidx < fidx; tidx++) 
        testchar = testchar + " " + failures[tidx];

    // Display test results
    if (fidx > 0)
        alert (fidx+" failures at lines:"+testchar);
    else
        alert ("All "+ (testnum-1) + " tests pass");

}

