//========================================================================
//                                                                       
// c_api.cpp                                              date: 2002/07/04    
//                                                                      
// Author: Simon Southwell                                              
//                                                                      
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                      
// $Id: c_api.cpp,v 1.1 2010-02-02 10:25:32 simon Exp $
//                                                                      
//========================================================================

//========================================================================
// C interface to compression codec. The lzw() function simply constructs
// a codec, passes on the command line arguments to the 'run' routine, and
// cleans up after it returns. It is exported as C so it may be inte-
// grated easily with other programs.
//========================================================================

//========================================================================
// Include files                                                         
//========================================================================

#include "codec.h"

#ifdef WIN32
 #ifdef __cplusplus
  #define DLLEXPORT extern "C"  __declspec ( dllexport )
 #else
  #define DLLEXPORT __declspec ( dllexport )
 #endif
#else
 #define DLLEXPORT
#endif     

//========================================================================
// Main code                                                             
//========================================================================

DLLEXPORT int lzw(int argc, char *argv[], char *errmsg)
{
    int status;

    // Create a Codec object 
    CodecClass *cptr = new CodecClass(errmsg);

    // Run the codec 
    status = cptr->run(argc, argv);

    // Delete the codec
    delete cptr;

    return(status);
}

#ifdef _NEED_TERMINATE_FUNCTION
void terminate(void){
    fprintf(stderr, "In the terminate() function!\n");
    exit(0);
}
#endif

