//=======================================================================
//                                                                       
// format.cpp                                            date: 2002/07/04 
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

//=======================================================================
// A class to display a stream of fixed size codewords in an 'xd' like
// way to an output stream. By default xterm contraol characters are
// inserted, but these may be configured out.
//=======================================================================

#include "format.h"

//=======================================================================
// Constructors and Desctructor                                          
//=======================================================================

FormatterClass::FormatterClass()
{
    set_formatter_mode(TRUE, FALSE, TRUE);
}

FormatterClass::FormatterClass(bool compmode=TRUE, bool formop=FALSE, bool prnt=TRUE)
{
    set_formatter_mode(compmode, formop, prnt);
}

FormatterClass::~FormatterClass()
{
}

//=======================================================================
// format()                                                              
//                                                                       
// Description:                                                          
//    Configure formatter mode for the differing outputs
//
//=======================================================================
void FormatterClass::set_formatter_mode(bool compmode, bool formop, bool prnt)
{
    compress_mode = compmode;
    formatted_output = formop;
    printable = prnt;
    code_number = -1;
}

//=======================================================================
// format()                                                              
//                                                                       
// Description:                                                          
//    Will output the value in 'code' in an 'xd' like formatted output.   
//                                                                       
//=======================================================================
void FormatterClass::_format(codeword_type code, FILE *ofp)
{

    if(!formatted_output)
        return;

    // We has a codeword, so up the count and check to see if we are 
    // at the end of a line 
    code_number++;
    if(code_number % MAX_VALUES_PER_LINE == 0) {

        // At end-of-line, so output 'NL' and start a new one
        // with the code count label '<count>:' 
        if(printable)
            fprintf(ofp, "\n%5d:",code_number);
        else
            fprintf(ofp, "\n%s%5d:%s", TERM_BOLD, code_number, TERM_OFF);

        // Start the line off as DIM by default 
        if(!printable)
            fprintf(ofp, "%s", TERM_OFF TERM_DIM);
        fprintf(ofp, " ");
    }


    if(!printable)
        fprintf(ofp, "%s", TERM_DIM);

    // Print the actual 12 bit codeword
    fprintf(ofp, "%03x", code);

    if(!printable)
       fprintf(ofp, "%s", TERM_OFF TERM_DIM);

    fprintf(ofp, " ");

    if(!printable)
        fprintf(ofp, "%s", TERM_OFF);
}

