/*************************************************************************/
/*                                                                       */
/* comp.c                                              date: 2002/07/02  */
/*                                                                       */
/* Author: Simon Southwell                                               */
/*                                                                       */
/* (c) 2002 Simon Southwell                                              */
/*                                                                       */
/*************************************************************************/
/*************************************************************************/
/*                                                                       */
/* This program loads the lzw.so shared object and calls it with the     */
/* command line arguments passed to main. The lzw() function must be     */
/* a C style linkage interface, even if a C++ program.                   */
/*                                                                       */
/*************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#define DLLBASENAME "lzw"

#ifndef WIN32

#include <dlfcn.h>

#define DLLHDL void *
#define DLLNAME DLLBASENAME ".so"

#else

#include <windows.h>

char *_error() {
    LPVOID lpMsgBuf;
    FormatMessage( 
        FORMAT_MESSAGE_ALLOCATE_BUFFER | 
        FORMAT_MESSAGE_FROM_SYSTEM | 
        FORMAT_MESSAGE_IGNORE_INSERTS,
        NULL, 
        GetLastError(), 
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), 
        (LPTSTR) &lpMsgBuf, 
        0, 
        NULL);
    return((char*) lpMsgBuf);
}

#define DLLHDL HANDLE
#define DLLNAME DLLBASENAME ".dll"
#define dlopen(_name, _args) LoadLibrary(TEXT(_name))
#define dlclose FreeLibrary
#define dlerror _error

#define RTLD_LAZY  0
#define RTLD_LOCAL 0

#endif

extern int lzw(int, char *[], char *);

main(int argc, char *argv[])
{
   DLLHDL handle;
   char errmsg[1024];

   /* Load the shared object into memory */
   handle = dlopen(DLLNAME, RTLD_LAZY | RTLD_LOCAL);


   /* Something went wrong opening the .so */
   if(handle == NULL) {
       fprintf(stderr, "***Error: problem dynamically loading object.\n");
       fprintf(stderr, "%s\n", dlerror());
       exit(1);
   }

   /* Call the codec top level function */
   if(lzw(argc, argv, errmsg)) {
       fprintf(stderr, "%s", errmsg);
   }

   /* Tidy up ... */
   dlclose(handle);

   /* Return good status */
   return(0);
}
