//=======================================================================
//                                                                       
// pack.cpp                                              date: 2002/07/04  
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

//=======================================================================
// The pack class takes fixed sized codewords, and 'packs' them into 
// variable length codewords, the size of which is passed in as this is
// determined by the dictionary.
//=======================================================================

#include "pack.h"

//=======================================================================
// Constructor and Destructor                                            
//=======================================================================

PackerClass::PackerClass()
{
    set_formatter_mode(TRUE, FALSE, TRUE);
    ip_codeword = NULLCW;
    barrel = 0;
    residue = 0;
    op_file = stdout;
    disable_output = FALSE;
}

PackerClass::PackerClass(bool compmode, FILE *ofp, bool formop, bool prnt)
{
    set_formatter_mode(compmode, formop, prnt);
    ip_codeword = NULLCW;
    barrel = 0;
    residue = 0;
    op_file = ofp;
    disable_output = formop;
}

PackerClass::~PackerClass()
{
}

//=======================================================================
//                                                                       
// Function name: pack                                                   
//                                                                       
// Description:                                                          
//    This routine packs valid LZW codewords into the appropriate        
//    sized packets (ie. 9 to 12 bits). The codeword length is passed
//    in as a parameter, as this is managed by the dictionary.
//                                                                       
//=======================================================================

unsigned int PackerClass::pack(codeword_type ip_codeword, unsigned int codeword_length)
{

    int byte_count = 0;


    // Send codeword off for formatting (if enabled)
    if(ip_codeword != NULLCW)
        format(ip_codeword, op_file);

    // Append codeword to the bottom of the barrel shifter
    barrel |= ((ip_codeword & CODEWORDMASK) << residue); 

    // If not the last (NULL) codeword, increment the number of bits on the
    // barrel shifter by the current codeword size
    if(ip_codeword != NULLCW)
        residue += codeword_length;

    // While there are sufficient bits, place bytes on the output. 
    // Normally this is whilst there are whole bytes, but the last (NULL)
    // codeword causes a flush of ALL remaining bits 
    while (residue >= ((ip_codeword != NULLCW) ? BYTESIZE : BITSIZE)) {                        
        if(!disable_output)
            putc((barrel & BYTEMASK), op_file);           
        byte_count++;                                  
        barrel >>= BYTESIZE;                          
        residue -= BYTESIZE;                          
    }                                                 

    // Return number of bytes output
    return(byte_count);
}
