//=======================================================================
//                                                                       
// codec.cpp                                             date: 2002/07/04  
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

//=======================================================================
// Includes                                                              
//=======================================================================

#if !defined(_CODEC_H_)
#define _CODEC_H_

#include <stdio.h>      // Standard I/O
#include <stdlib.h>     // Standard library
#include <string.h>     // C String library

#include "lz.h"         // Common LZ defintions      
#include "dict.h"       // Dictionary definitions    
#include "pack.h"       // Packer definitions        
#include "comp.h"       // Compression definitions   
#include "decomp.h"     // Decompression definitions 

extern "C" int getopt(int, char **, char *);
extern "C" char * optarg;

#ifndef WIN32
#include <dlfcn.h>
#endif

//=======================================================================
// Codec class definition                                                
//=======================================================================

class CodecClass 
{
public:
    CodecClass(char *);
    ~CodecClass();

public:
    int run(int, char **);

private:
    int set_user_config(int, char **);

    // Pointers to the codec objects
    DictClass     *dptr;
    CompClass     *cptr;
    PackerClass   *pptr;
    DecompClass   *dcptr;
    UnpackerClass *uptr;

    // The following variables are initialised to the equivalent of
    // a hardware reset. 
    bool compress_mode;
    codeword_type previous_codeword;

    // The following variables are not used by the algorithm - they
    // are only for stats or graphics 
    bool graph;
    FILE *graph_file;

    // IO configuration 
    char *ip_filename, *op_filename;
    FILE *ifp, *ofp;

    // Screen dump control
    bool formatted_output;
    bool printable;
    bool dict_dump;

    int config_max_str_len;

    char *errmsg;
};

#endif
