//=======================================================================
//                                                                       
// comp.h                                                date: 2002/07/04    
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

#if !defined (_COMP_H_)
#define _COMP_H_

#include <stdio.h>              // Standard I/O 
#include <stdlib.h>             // Standard library
#include "lz.h"                 // Common LZW defintions 
#include "dict.h"		// Dictionary class definitions
#include "pack.h"	        // Packer class definitions 

//=======================================================================
// Constant definitions                                                  
//=======================================================================

// Define stats and graphics constants 
#define DATA_POINT_PERIOD 128

//=======================================================================
// comp class definition                                                 
//=======================================================================

class CompClass 
{
public:
    CompClass(void);
    CompClass(int, FILE *, bool, FILE *);
    ~CompClass();

public:
    void compress(DictClass *, PackerClass *);

private:
    void output_graphics_data_point (void);

    inline int  get_max_string_length(void)
        { return(max_string_length); };
    inline void set_max_string_length(int val)
        { max_string_length = val; };
    inline codeword_type  convert_to_rootcw(short int byte) 
        { return ((codeword_type)byte); };
    inline void set_graph(bool val, FILE *fp)
        { graph = val; graph_file = fp; };

private:
    unsigned int match_length_so_far;
    dictionary_address_type match_addr;
    short int ipbyte;
    unsigned int code_size;

    codeword_type previous_codeword;
    unsigned int ip_bytecount, op_bytecount;
    int max_string_length;
    bool graph;
    FILE *graph_file, *ip_file;

};
#endif
