//=======================================================================
//                                                                       
// decomp.h                                              date: 2002/07/04  
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

#if !defined(_DECOMP_H_)
#define _DECOMP_H_

#include <stdio.h>              // Standard I/O
#include <stdlib.h> 
#include "lz.h"                 // Common LZ defintions 
#include "unpack.h"		// Unpacker class definitions
#include "dict.h"		// dictionary class definitions
#include "stack.h"		// stack class definitions

//=======================================================================
// Class prototypes                                                   
//=======================================================================

class DecompClass : public StackClass
{
public:
    DecompClass();
    DecompClass(int, FILE *, char *);
    ~DecompClass();

public:
    int decompress (DictClass *, UnpackerClass *);

private:
    char output_linked_list (DictClass *, UnpackerClass *, int *);

    inline void reset_decompression_engine (void)
        { previous_codeword = NULLCW; reset_stack(); };
    inline byte_type root_byte_value(codeword_type codeword) 
        { return((byte_type)codeword); };

private:
    // Configurable parameter
    int max_string_length;

    // Algorithm variables 
    codeword_type previous_codeword;
    unsigned int ip_bytecount, op_bytecount;
    unsigned int last_word_length;
    codeword_type ip_codeword;
    byte_type string_terminator_byte;
    unsigned int code_size;
    FILE *op_file;
    char *errmsg;

};

#endif

