//=======================================================================
//                                                                       
// dict.h                                                date: 2002/07/04  
//                                                                       
// Authors: Simon Southwell                                              
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

#if !defined(_DICT_H_)
#define _DICT_H_

//=======================================================================
// Includes                                                              
//=======================================================================

#include <stdio.h>
#include <stdlib.h>
#include "lz.h"

//=======================================================================
// Dictionary entry class                                                
//=======================================================================

class dictionary_entry_type
{
public:
    pointer_type pointer;
    byte_type    byte;
};

//=======================================================================
// Dictionary class                                                      
//=======================================================================

class DictClass
{
public:
    // Constructor/destructor declarations
    DictClass();
    DictClass(bool);
    ~DictClass();

public:
    
    unsigned int reset_dictionary (void);

    // Update dictionary state
    unsigned int build_entry (codeword_type codeword, byte_type byte);

    // Check dictionary status
    dictionary_address_type entry_match (dictionary_address_type address, byte_type byte);

    inline bool codeword_valid (codeword_type codeword)
        { return(codeword <= next_available_codeword); };
    inline bool is_next_free_entry (dictionary_address_type address) 
        { return(address == next_available_codeword); };
    inline bool dictionary_full (void)
        { return(next_available_codeword == DICTFULL); };
    inline byte_type dictionary_entry_byte (dictionary_address_type address)
        { return(dictionary[address].byte); };
    inline pointer_type dictionary_entry_pointer (dictionary_address_type address)
        { return(dictionary[address].pointer); };
    inline int root_codeword (pointer_type codeword) 
        { return (codeword < FIRSTCW); };

    // Diagnostics and debug
    int dump_dictionary (char *);

private:
    inline void set_dictionary_entry_pointer (dictionary_address_type address, pointer_type pointer)
        { dictionary[address].pointer = pointer; };
    inline void set_dictionary_entry_byte (dictionary_address_type address, byte_type byte)
        { dictionary[address].byte = byte; };

private:
    // Internal data structures
    codeword_type indirection_table[DICTFULL][NUMOF8BITBYTES];
    dictionary_entry_type dictionary[DICTFULL];
    codeword_type next_available_codeword;
    bool compress_mode;
    unsigned int codeword_len;

};
#endif
