//=======================================================================
//                                                                       
// format.cpp                                            date: 2002/07/04 
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================
                                                                       
#if !defined(_FORMAT_H_)
#define _FORMAT_H_

#include <stdio.h>
#include "lz.h"

//=======================================================================
// Constants                                                             
//=======================================================================

// Data format definitions 

#define MAX_TABLE_SIZE      100
#define MAX_VALUES_PER_LINE 16

// Define terminal control codes for xterm. ( ^[ really is just one
// character <Escape> ). For use on other terminals, it might be better
// to use the curses library . 

#define TERM_OFF     "[0m"
#define TERM_DIM     "[2m"
#define TERM_REVERSE "[7m"
#define TERM_BOLD    "[1m"

#define RESETSTR     "RST"
#define EORSTR       "EOR"
#define GROWSTR      "GRW"
#define RSRVDSTR     "RCW"
#define PRNTPRMARK   "!"
#define PRNTLINEMARK "<-"

//=======================================================================
// Class definition                                                      
//=======================================================================

class FormatterClass
{
public:
    FormatterClass();
    FormatterClass(bool, bool, bool);
    ~FormatterClass();

public:
    // Only call the main format method if enabled. This inline function
    // saves time when called from the packer or unpacker
    inline void format(codeword_type code, FILE *ofp) 
        { if(!formatted_output) return; else _format(code, ofp); };
       
    void set_formatter_mode(bool, bool, bool);
    bool is_formatted_output(void){ return formatted_output;};

private:

    bool compress_mode;
    bool printable;
    bool formatted_output;

    // Proper format method
    void _format(codeword_type, FILE *);

    // Counter of codewords, used for line termination etc. 
    int code_number;

    // Current code length. Only used to highlight 'bad code length' errors 
    unsigned int code_length;

};

#endif
