//=======================================================================
//                                                                       
// lz.h                                                  date: 2002/07/04  
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

//=======================================================================
// Constant definitions                                                  
//=======================================================================

#if !defined(_LZ_H_)
#define _LZ_H_

#define TRUE      		(1==1)
#define FALSE     		(1==0)
#define SUCCESS   		TRUE
#define FAILURE   		FALSE

#define NEWLINE                 0x0A

#define BYTESIZE  		8
#define BYTEMASK  		0xff
#define BITSIZE  		1
#define NUMOF8BITBYTES          0x100
#define DEFAULTSTRSIZE          20

#define DEFAULTRECSIZE 		0

#define EOR 			TRUE
#define NO_EOR 			FALSE

#define RESCWNUM 8
#define FIRSTROOTCW 		0x000
#define FIRSTCW 		0x100
#define NULLCW 			0xFFFF
#define EOFFLUSH                NULLCW

#define MINCWLEN 		9
#define MAXCWLEN 		12
#define MAXWORDLENGTH 		(1 << MAXCWLEN)

#define DICTFULL 		(1 << MAXCWLEN)
#define NOMATCH  		DICTFULL
#define MAXDICTSIZE             DICTFULL

#define CODEWORDMASK            ((1 << MAXCWLEN) - 1)

#define NOERROR                 0
#define USER_ERROR 		1
#define DECOMPRESSION_ERROR 	2
#define PACKER_ERROR 		3
#define UNPACKER_ERROR 		4

#define GRAPHFILENAME           "lzw.graph"
#define DICTDUMPFNAME           "lzw.dict"

//=======================================================================
// Type/Structure definitions                                            
//=======================================================================

typedef unsigned int   record_size_type;
typedef unsigned int   dictionary_address_type;
typedef unsigned int   codeword_type;
typedef unsigned int   pointer_type;
typedef unsigned char  byte_type;

#endif
