//=======================================================================
//                                                                       
// pack.h                                                date: 2002/07/04 
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

#if !defined (_PACK_H_)
#define _PACK_H_

//=======================================================================
// Includes                                                              
//=======================================================================

#include <stdio.h>              // Standard I/O 
#include <stdlib.h>
#include "lz.h"                 // Common LZ defintions 
#include "format.h"		// Screen dump formatter class definitions

//=======================================================================
// Class definition                                                      
//=======================================================================

class PackerClass : public FormatterClass
{
public:
    PackerClass();
    PackerClass(bool, FILE *, bool, bool);
    ~PackerClass();

public:
    // Main pack routine
    unsigned int pack(codeword_type, unsigned int);

private:

    // Stats & config values
    codeword_type ip_codeword;

    FILE *op_file;

    // Barrel shift register used to formulate the output bytes 
    unsigned long barrel;

    // The residue count of unflushed bits left on the barrel shifter 
    int residue;

    bool disable_output;
};
#endif
