//=======================================================================
//                                                                       
// stack.h                                               date: 2002/07/04  
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

#if !defined(_STACK_H_)
#define _STACK_H_

#include "lz.h"

// Implements a simple stack mechanism. The stack is fixed
// size, based on the maximum size of the dictionary

class StackClass
{
public:
    StackClass() {};
    ~StackClass() {};

public:
    inline void reset_stack(void) { stack_pointer = 0;};
    inline unsigned int stack_size(void) {return stack_pointer;};
    inline int stack_empty(void) {return(stack_pointer == 0);};
    inline void push(byte_type Value) {buf[stack_pointer++] = Value;};
    inline byte_type pop(void) {return(buf[--stack_pointer]);};

private:
    byte_type buf[MAXWORDLENGTH];
    unsigned int stack_pointer;
};

#endif

