//=======================================================================
//                                                                       
// unpack.h                                              date: 2002/07/04  
//                                                                       
// Author: Simon Southwell                                               
//                                                                       
// Copyright (c) 2002 Simon Southwell                                                                     
//                                                                       
// $Revision: 1.1 $
//                                                                      
//=======================================================================

//=======================================================================
// Includes                                                              
//=======================================================================

#if !defined (_UNPACK_H_)
#define _UNPACK_H_

#include <stdio.h>              // Standard I/O
#include <stdlib.h> 
#include "lz.h"                 // Common LZ defintions 
#include "format.h"		// Screen dump formatter class definitions

//=======================================================================
// External globals                                                      
//=======================================================================

class UnpackerClass : public FormatterClass
{
public:
    // Constructor(s), Destructors
    UnpackerClass();
    UnpackerClass(bool, FILE *, FILE *, bool, bool);
    ~UnpackerClass();

    // Main unpack calling routine 
    unsigned int unpack(codeword_type *, unsigned int);

private:
    short int ipbyte;
    unsigned int currlen, barrel;
    codeword_type op_codeword;

    codeword_type delay_op_codeword;
    bool delay_enable;

    unsigned short codeword_length;

    FILE * ip_file, * op_file;
};

#endif

